unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    procedure FormCreate(Sender: TObject);
    procedure StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  i,j : Integer;
begin
  for i := 0 to 4 do
    for j := 0 to 4 do
      StringGrid1.Cells[i,j] := '('+IntToStr(i)+';'+IntToStr(j)+')';
end;

procedure TForm1.StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var
  OldAlign : Integer;
begin
// s desenha se for clula fixa
  if gdFixed in State then begin
// seta alinhamento cetralizado e pega alinhamento antigo
    OldAlign := SetTextAlign(StringGrid1.Canvas.Handle,TA_CENTER);
// desenha o texto da clula
    StringGrid1.Canvas.TextRect(Rect,(Rect.Left+Rect.Right) div 2, Rect.Top + 2,StringGrid1.Cells[ACol,ARow]);
// volta ao alinhamento antigo
    SetTextAlign(StringGrid1.Canvas.Handle,OldAlign);
  end;
end;

end.
